% Created by Ramesh Neelamani, Rice University on 11/9/99
%
% This file contains various examples to demonstrates the usage of the
% files in CWT directory. 
%
% Reference: 
% "WInHD: Wavelet-based Inverse Halftoning via Deconvolution",
% R. Neelamani, R. Nowak, R. Baraniuk, Submitted to the IEEE
% Transactions on Image Processing, September 2002. Available for
% download from http://www.dsp.rice.edu/publications/
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% This simply adds the mtools and images directory to the current  matlab
% path.

addpath '../winhdmtools' -begin
addpath '../winhdimages' -begin
 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Example 1 : Inverse Halftone Floyd halftoned image (Lena image)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

disp('Example 1: Inverse Halftone Floyd halftoned image (Lena image)')
x = double(imread('lena.tif')); 
y = double(imread('lena_floyd_ht.tif'));  % precomputed halftone
disp('Computing inverse halftone')
WInHD_estimate = IHT_Floyd_cwt(y,x);
disp('Pausing: Hit return to continue to next example')
figure(1)
imagesc(WInHD_estimate);
imset
title('WInHD (with CWT) estimate for Floyd')
pause

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Example 2 : Inverse Halftone Jarvis halftoned image (Lena image)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

disp('Example 2: Inverse Halftone Jarvis halftoned image (Lena image)')
x = double(imread('lena.tif')); 
y = double(imread('lena_jarvis_ht.tif'));  % precomputed halftone
disp('Computing inverse halftone')
WInHD_estimate = IHT_Jarvis_cwt(y,x);
disp('Pausing: Hit return to continue to next example')
figure(1)
imagesc(WInHD_estimate);
imset
title('WInHD (with CWT) estimate for Jarvis')


