
#include "msp430.h"

void i2c_setup();
void i2c_out(int i);
void i2c_send_byte(unsigned char b);
void i2c_start();
void i2c_stop();



void
i2c_setup()
	{
	P1DIR |= 0xC0;							// set P1.6, p1.7 as outputs
	
	// setup USI for I2C operation
	USICTL0 = USIPE6+USIPE7+USIMST+USISWRST; // Port & USI mode setup
	USICTL1 = USII2C;                        // Enable I2C mode
	USICKCTL = USIDIV_6+USISSEL_2+USICKPL;   // Setup USI clocks: SCL = SMCLK/64 (~125kHz)
//	USICKCTL = USIDIV_5+USISSEL_2+USICKPL;   // Setup USI clocks: SCL = SMCLK/32 (~250kHz)
 	USICTL0 &= ~USISWRST;                   // Enable USI 
	}

void
i2c_out(int i)
	{
	// put out a command packet to the ADC
	// format: address, command, lsB, msB
	i2c_start();
	i2c_send_byte(0x40);	// address
	i2c_send_byte(0);		// command: use default modes
	i2c_send_byte(i&0xff);	// ls byte
	i2c_send_byte((i>>8)&0xff);		// ms byte
	i2c_stop();
	}

void
i2c_send_byte(unsigned char b)
	{
	volatile unsigned int i;            // volatile to prevent optimization

	USISRL=b;			// load data into shift register
	USICTL0 |= USIOE;	// enable output
	USICNT = 8;
	while((USICTL1 & USIIFG)==0)
		;
	
	// recieve ACK
	USICTL0 &= ~USIOE;	// disable output
	USICNT=1;
	while((USICTL1 & USIIFG)==0)
		;

	if(USISRL&0x01){	// NAK
		P1OUT &= ~0x07;		// turn off LED
		while(1)			// hang
			;
		}
	}

void
i2c_start()
	{
	USISRL=0;	// set MSB to zero
	USICTL0 |= USIGE+USIOE;	// latch/SDA output enabled
	USICTL0 &= ~USIGE;		// latch disabled
	}

void
i2c_stop()
	{
	USICTL0 |= USIOE;	// SDA=output
	USISRL = 0;			// MSB = 0
	USICNT = 1;			// for one clock
	// wait until USIIFG clear
	while((USICTL1 & USIIFG)==0)
		;
	USISRL=0xFF;			// to drive SDA high
	USICTL0 |= USIGE;		// transparent latch enabled
	USICTL0 &= ~(USIGE+USIOE);		// latch/SDA output disabled
	}
