//******************************************************************************
//  MSP430 motor speed control
//******************************************************************************

#include "msp430.h"

#define PWM_OUT 0x04				// bit2 of Port1 / TA1  
#define Period 0xff					// Counts for D/A, 8bits = 256 

int ad_read(int chan);

int main(void)
	{
	register int duty_cycle;
	
	WDTCTL = WDTPW + WDTHOLD;		// Stop watchdog timer
	
	// set clock to 8MHz
  	BCSCTL1 = CALBC1_8MHZ;
	DCOCTL = CALDCO_8MHZ;
	
	// setup ADC
	ADC10CTL0 = ADC10SHT_2 + ADC10ON + REF2_5V + REFON + SREF_1;
									// ADC10 on/enable
                                    // sample/hold time = 16 clocks
                                    // Vr+ = VREF+, Vr- = VSS
                                    // VREF=2.5V
	ADC10CTL1 = INCH_5;				// select analog input A5
	ADC10AE0 |= 0x30;				// enable analog input pins A4 & A5
	
	// setup P1
	P1OUT = 0;						// P1OUT reset
	P1SEL |= PWM_OUT;				// P1.2/TA1 for PWM OUT
	P1DIR |= 0x07;					// Set P1.0-P1.2 to output direction
	
	// setup timer
	CCR0 = Period;				// Set Period length for PWM output
	CCR1 = 0;					// Initial PWM value for output
	CCTL1 = OUTMOD_7;			// Set output mode 7 for TA1
	TACTL = TASSEL1+MC0;		// Set TimerA Up mode, SMCLK as TACLK
	
	duty_cycle = 0;

	for (;;){
    	volatile unsigned int i,j;	// volatile to prevent optimization

    	P1OUT ^= 0x01;				// flash the LED

		P1OUT |= 0x02;				// set P1.1 before call of ad_read
		duty_cycle = ad_read(INCH_5);// read ch_5 into duty_cycle
		P1OUT &= ~0x02;				// clear P1.1 when A/D read complete
		duty_cycle >>= 2;			// shift down to 8 bits
		CCR1 = duty_cycle;			// send value to PWM out
  		}
	}

// read and return analog value from specified channel
int ad_read( int chan)
	{
	ADC10CTL1 = chan;
	ADC10CTL0 |= ENC+ADC10SC;	// sample and start conversion
	while(ADC10CTL1 & ADC10BUSY)// wait for conversion to complete
		;
	return(ADC10MEM);
	}


