//******************************************************************************
//  MSP430 motor speed control
//******************************************************************************

#include "msp430.h"

void i2c_setup();
void i2c_out(int i);

#define PWM_OUT 0x04				// bit2 of Port1 / TA1  
#define Period 0xff					// Counts for D/A, 8bits = 256 

void delay();
int ad_read(int chan);

int main(void)
	{
	register int duty_cycle;
	int i, c, i0;
	
	WDTCTL = WDTPW + WDTHOLD;		// Stop watchdog timer
	
	// set clock to 8MHz
  	BCSCTL1 = CALBC1_8MHZ;
	DCOCTL = CALDCO_8MHZ;
	
	// setup ADC
	ADC10CTL0 = ADC10SHT_2 + ADC10ON + REF2_5V + REFON + SREF_1;
									// ADC10 on/enable
                                    // sample/hold time = 16 clocks
                                    // Vr+ = VREF+, Vr- = VSS
                                    // VREF=2.5V
	ADC10CTL1 = INCH_5;				// select analog input A5
	ADC10AE0 |= 0x38;				// enable analog input pins A4 & A5
	
	// setup P1
	P1OUT = 0;						// P1OUT reset
	P1SEL |= PWM_OUT;				// P1.2/TA1 for PWM OUT
	P1DIR |= 0x07;					// Set P1.0-P1.2 to output direction
//	P1DIR |= 0x40;					// Set P1.6 direction to output
	
	
	// setup timer
	CCR0 = Period;				// Set Period length for PWM output
	CCR1 = 0;					// Initial PWM value for output
	CCTL1 = OUTMOD_7;			// Set output mode 7 for TA1
	TACTL = TASSEL1+MC0;		// Set TimerA Up mode, SMCLK as TACLK
	
	// setup i2c DAC
	i2c_setup();
	
	duty_cycle = 0;
	CCR1 = duty_cycle;			// force output to be zero;
	delay();					// wait
	for(i=0, i0=1024; i<100; i++){
		c=ad_read(INCH_4);		// read the current sense offset
		if(c<i0) i0=c;			// get the minimum to prevent overflow;
		}

	for (;;){
    	P1OUT ^= 0x01;				// flash the LED

		// read the control voltage and set the duty cycle
		P1OUT |= 0x02;				// set P1.1 before call of ad_read
		duty_cycle = ad_read(INCH_5);// read ch_5 into duty_cycle
		P1OUT &= ~0x02;				// clear P1.1 when A/D read complete
		duty_cycle >>= 2;			// shift down to 8 bits
		CCR1 = duty_cycle;			// send value to PWM out
		
		//read the current and send to the DAC
		c=ad_read(INCH_4)-i0;
		i2c_out(c);
		c = c*.05;
  		}
	}

// read and return analog value from specified channel
int ad_read( int chan)
	{
	ADC10CTL1 = chan;
	ADC10CTL0 |= ENC+ADC10SC;	// sample and start conversion
	while(ADC10CTL1 & ADC10BUSY)// wait for conversion to complete
		;
	ADC10CTL0 &= ~(ENC+ADC10SC);
	return(ADC10MEM);
	}

void delay()
	{
	volatile unsigned int i=100;
	
	do{i--;} while(i!=0);
	}

